﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Syndication;
using System.ServiceModel.Web;
using System.Text;

namespace $safeprojectname$
{
	// 注意: 使用“重构”菜单上的“重命名”命令，可以同时更改代码和配置文件中的类名“Feed1”。
	public class Feed1 : IFeed1
	{
		public SyndicationFeedFormatter CreateFeed()
		{
			// 新建整合源。
			SyndicationFeed feed = new SyndicationFeed("Feed Title", "A WCF Syndication Feed", null);
			List<SyndicationItem> items = new List<SyndicationItem>();

			// 新建整合项。
			SyndicationItem item = new SyndicationItem("An item", "Item content", null);
			items.Add(item);
			feed.Items = items;

			// 根据查询字符串返回 ATOM 或 RSS
			// rss -> http://localhost:8733/Design_Time_Addresses/$safeprojectname$/Feed1/
			// atom -> http://localhost:8733/Design_Time_Addresses/$safeprojectname$/Feed1/?format=atom
			string query = WebOperationContext.Current.IncomingRequest.UriTemplateMatch.QueryParameters["format"];
			SyndicationFeedFormatter formatter = null;
			if (query == "atom")
			{
				formatter = new Atom10FeedFormatter(feed);
			}
			else
			{
				formatter = new Rss20FeedFormatter(feed);
			}

			return formatter;
		}
	}
}
